define([
    'underscore',
    'marionette',
    'text!modules/new-appointment-request/views/common/city-state/template.html',
], function(_, Mn, template) {
    'use strict';


    return Mn.View.extend({
        tagName: 'fieldset',
        className: 'form-section',
        template: _.template(template),
        ui: {cityState: '#cityState'},
        events: {'change @ui.cityState': 'updateModel'},

        serializeData: function() {
            return {states: this.collection.group()};
        },

        onRender: function() {
            var model;
            var code;

            if (this.collection.length === 1) {
                model = this.collection.first();
                code = model.get('institutionCode');
                this.ui.cityState.val(code);
                this.ui.cityState.trigger('change');
            }
        },

        updateModel: function(event) {
            var value = event.target.value;
            var model = this.collection.get(value);
            this.model.set('cityState', model);
        },
    });
});
